package org.jcon.param.tree;

import java.util.Vector;

/**
 * Represents a container node in a data hierarchy.
 *
 * @author Jack Harich
 */
public abstract class DatumBranch extends Datum {

//---------- Private Fields ------------------------------
protected String branchName;

//---------- Initialization ------------------------------
public DatumBranch() {
    super();
    node.setAllowsChildren(true);
}
//---------- Abstract Implementation ---------------------
//----- From Datum
public final boolean isLeaf() {
    return false;
}
// Note we do not implement abstract toString()
//---------- Abstract Methods ----------------------------
/**
* Inserts the named datum before the relativeName. If the
* relativeName is null then it is inserted at the end.
* Throws an IllegalStateException if the relativeName is
* not null and not found.
*
* @return 
*/
public abstract Datum insertDatum(String name, Datum datum,
                        String relativeName);
        
/**
* Returns a Vector of all Datums in proper order.
*/        
public abstract Vector getDatums();

/**
* Removes the named Datum. Returns the Datum removed or
* null if none.
*/
public abstract Datum removeDatum(String name);


//---------- Properties ----------------------------------
public void setBranchName(String branchName) {
    this.branchName = branchName;
}
public String getBranchName() {
    return branchName;
}
//---------- Public Methods ------------------------------

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("DatumBranch" + text);
}

} // End class
