package org.jcon.param.tree;

/**
 * Represents a comment, such as "// This is declarative knowledge".
 *
 * @author Jack Harich
 */
public class Comment extends DatumLeaf {


//---------- Abstract Implementation ---------------------
//----- From Datum
// The text to be displayed in the tree
public String toString() {
    // Do not use myName, which contains a comment ID
    return "//" + myValue;
}
public void performCommand(DatumCommand command) {
    print(".performCommand() not yet implemented");
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("Comment" + text);
}

} // End class
