package org.jcon.param.stream;

import org.jcon.param.Param;
import org.jcon.param.ParamStore;
import org.jcon.param.ParamStoreResource;
import java.io.IOException;

/**
 * This class provides a ParamStore in the form of a
 * ParamOutputStream sink.
 *
 * @author Jack Harich
 */
public class ParamStoreSink implements ParamOutputStream {

//---------- Private Fields ------------------------------
private ParamStore paramStore = new ParamStoreResource();

//---------- ParamOutputStream Implementation ------------
public void writeParam(Param param) throws IOException {
    try {
        boolean success = paramStore.writeParam(param, null);
        if (! success) throw new IOException("Write param failure."); 
           
    } catch(Exception ex) {
        ex.printStackTrace();
        throw new IOException(ex.getMessage());
    }
}
public void setParamOutput(ParamOutputStream output) {
    throw new IllegalStateException("This class is a param sink.");
}
public boolean isParamSink() {
    return true;   
} 
//--- Std
private static void print(String text) {
    System.out.println("ParamStoreSink" + text);
}

} // End class
