package org.jcon.param.stream;

import org.jcon.param.Param;
import java.io.IOException;

/**
 * This interface defines an output stream that accepts
 * Param objects. It's designed to make it easy to assemble
 * components into a Param processing pipeline, which is
 * a higher order than java.io.OutputStream.
 *
 * @author Jack Harich
 */
public interface ParamOutputStream {

/**
 * The implementer should process the param, and in many
 * cases will then pass it along to the next filter in the
 * pipeline.
 */
public void writeParam(Param param) throws IOException;

/**
 * Sets the next filter in the pipeline, which is where the
 * param is output to. A sink should throw an 
 * IllegalStateException if this is called.
 * <p>
 * We use a method here, rather than the constructor, to
 * set the next filter. This allows easier system assembly.
 */
public void setParamOutput(ParamOutputStream output);

/**
 * Returns true if this is a sink, false if not. A sink
 * will not output Params written to it, and is the end
 * of the pipeline. This unusual method allows classes to
 * be easily inspected for intended use.
 */
public boolean isParamSink();


} // End interface
    
/**
//---------- ParamOutputStream Implementation ------------
public void writeParam(Param param) throws IOException {
    // *** do ***       
}
public void setParamOutput(ParamOutputStream output) {
    this.output = output;
}
public boolean isParamSink() {
    return true;   
} 
*/    
