package org.jcon.param.stream;

import org.jcon.param.Param;
import org.jcon.param.ParamAccessor;
import org.jcon.param.ParamStore;
import org.jcon.util.GenLib;
import java.io.IOException;

/**
 * This class is a ParamOutputStream source by outputting
 * Params given file names.
 *
 * @author Jack Harich
 */
public class ParamFileSource {

//---------- Private Fields ------------------------------
// Properties
private ParamOutputStream output;
private ParamStore        paramStore;
private Object            markerClass;

//---------- ParamOutputSource Implementation ------------
// *** Later implement ParamOutputSource ***
public void setParamOutput(ParamOutputStream output) {
    this.output = output;
}
//---------- Properties ----------------------------------
public void setParamStore(ParamStore paramStore) {
    this.paramStore = paramStore;
}    
//----- markerClass
public void setMarkerClass(Object markerClass) {
    this.markerClass = markerClass;
}  
public Object getMarkerClass() {
    return markerClass;        
}      
//---------- Public Methods ------------------------------
public void writeFileNames(String[] fileNames) {
    for (int i = 0; i < fileNames.length; i++) {
        // Create Param to process
        String fileName = fileNames[i];
        print(".writeFileNames() - Processing " + fileName);
        ParamAccessor accessor = new ParamAccessor(markerClass, fileName);
        Param param = paramStore.readParam(accessor);   
        // Send Param down pipeline
        try {
            output.writeParam(param);
        } catch(IOException ex) {
            GenLib.exception("ParamFileSource.writeFileNames()",
                "Cannot write '" + fileName + "' to pipeline.\nWill continue with the rest.", ex);   
        }
    }
}    
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ParamFileSource" + text);
}

} // End class
