package org.jcon.param.stream;

import org.jcon.param.Param;
import org.jcon.util.GenLib;
import java.io.IOException;
import java.util.Vector;

/**
 * This class is a ParamOutputStream filter by receiving
 * Params and outputting the elements found in each Param.
 *
 * @author Jack Harich
 */
public class ParamElementFilter implements ParamOutputStream {

//---------- Private Fields ------------------------------
private ParamOutputStream output;
private String            elementsName;

//---------- ParamOutputStream Implementation ------------
public void writeParam(Param param) throws IOException {
    // Extract Param elements and send down pipeline
    Vector elements = param.getVector(elementsName);
    for (int i = 0; i < elements.size(); i++) {
        Param elementParam = (Param)elements.elementAt(i);
        // Send Param down pipeline
        try {
            output.writeParam(elementParam);
        } catch(IOException ex) {
            // *** Need to identify element better ***
            print(".writeParam() - Element:\n" + elementParam);
            GenLib.exception("ParamElementFilter.writeParam()",
                "Cannot write element '" + i + "' to pipeline.\nWill continue with the rest.", ex);   
        }            
    }
}
public void setParamOutput(ParamOutputStream output) {
    this.output = output;
}
public boolean isParamSink() {
    return true;   
}  
//---------- Properties ----------------------------------
public void setElementsName(String elementsName) {
    this.elementsName = elementsName;
}    
public String getElementsName() {
     return elementsName;   
}    
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ParamElementFilter" + text);
}

} // End class
