package org.jcon.param.stream;

import org.jcon.param.Param;
import org.jcon.param.ParamStore;
import org.jcon.param.ParamStoreResource;

/**
 * This class configures files containing Params. If uses
 * "ConfigDef" Param files to do this.
 *
 * @author Jack Harich
 */ // java org.jcon.param.stream.ConfigParamFiles
public class ConfigParamFiles {

//---------- Private Fields ------------------------------
private ParamStore paramStore;

//---------- Initialization ------------------------------
/**
 * Runs the unit test for this class, using this class and
 * the command line arguments as fileNames. If the fileNames
 * are empty a default of "TestConfigDef.parex" is supplied.
 */
public static void main(String fileNames[]) {
    // Run unit test
    if (fileNames.length == 0) {
        fileNames = new String[] {"TestConfigDefs.parex"};
    }
    ConfigParamFiles test = new ConfigParamFiles();
    test.configFiles(test, fileNames);
}    
//---------- Properties ----------------------------------
/**
 * Sets the ParamStore to be used. If not provided a
 * ParamStoreResource is used.
 */
public void setParamStore(ParamStore paramStore) {
    this.paramStore = paramStore;
}   
public ParamStore getParamStore() {
    return paramStore;   
}
//---------- Public Methods ------------------------------
/**
 * Configures the Param fileNames which are located relative
 * to the markerClass. This flexible approach allows the files
 * to be located anywhere, as long as they are relative to
 * the markerClass. This avoids fixed full file names, 
 * which are not platform portable and are hard to manage.
 */
public void configFiles(Object markerClass, String[] fileNames) {
    if (paramStore == null) paramStore = new ParamStoreResource();
    
    //----- Init pipeline members
    // First is source, rest are ParamOutputStream's
    // Sink is paramStore
    ParamFileSource    paramFileSource = new ParamFileSource();
        paramFileSource.setParamStore(paramStore);
        paramFileSource.setMarkerClass(markerClass);
        
    ParamElementFilter paramElementFilter = new ParamElementFilter();
        paramElementFilter.setElementsName("ConfigDefs");
        
    ParamSubstituter   paramSubstituter = new ParamSubstituter();
        paramSubstituter.setParamStore(paramStore);
        
    ParamStoreSink sink = new ParamStoreSink();
    
    //----- Hookup pipeline members
    paramFileSource   .setParamOutput(paramElementFilter);
    paramElementFilter.setParamOutput(paramSubstituter);
    paramSubstituter  .setParamOutput(sink);
    
    //----- Start pipeline
    paramFileSource.writeFileNames(fileNames);
}    
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ConfigParamFiles" + text);
}

} // End class
