package org.jcon.param.schema;

import org.jcon.param.Param;
import org.jcon.util.DataLib;
import java.util.Hashtable;
import java.util.Vector;

/**
 * Contains the Branchs which comprise a DatumBranch schema.
 *
 * @author Jack Harich
 */
public class BranchSchema {

//---------- Private Fields ------------------------------
// Key = name, Object = Branch
private Hashtable branchs = new Hashtable();

private BranchFactory branchFactory = new BranchFactory();

//---------- Properties ----------------------------------

//---------- Public Methods ------------------------------
/**
 * Sets the param used to initialize the schema. The param
 * should contain a list of BranchTypes and classNames.
 * This should be done before other class calls.
 */
public void setParam(Param param) {
    // Load BranchTypeClasses into factory
    branchFactory.removeAll();
    Vector list = param.getVector("BranchTypeClasses");
    for (int i = 0; i < list.size(); i++) {
        String line = (String)list.elementAt(i);
        //print(".setParam() - line = " + line);
        String args[] = DataLib.convertDelimStringToArray(line, ", ");
        branchFactory.putBranchClass(args[0].intern(), args[1]);
    }
    // *** Perhaps more init later
}
/**
 * Adds a Branch to the schema by creating one from the
 * param. The param must contain the properties BranchName and
 * BranchType. The BranchType must have been previously
 * added to the schema, such as with setParam().
 * Returns null or the previous Branch with the Name in
 * the param. Also sets the Branch's schema to this.
 */
public Branch addBranchParam(Param param) {
    // ***String name = param.getString("BranchName");
    Branch branch = branchFactory.createBranch(param);
    branch.setSchema(this);
    return (Branch)branchs.put(branch.getName().intern(), branch);
}
/**
 * Returns the named Branch or null if not found.
 */
public Branch getBranch(String name) {
    return (Branch)branchs.get(name);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("BranchSchema" + text);
}

} // End class
