package org.jcon.param.schema; 

import org.jcon.param.Param;
import org.jcon.util.GenLib;
import java.util.Hashtable;

/**
 * Creates Branchs given the Param they will use.
 * Requires a Branch class for each BranchType.
 *
 * @author Jack Harich
 */
public class BranchFactory {

//---------- Private Fields ------------------------------
// Key = BranchType, Object = String className
private Hashtable branchTypes = new Hashtable();

//---------- Public Methods ------------------------------
/**
 * Puts the class for the branchType in the factory. The
 * class will be used for creating Branchs for the
 * branchType. Returns null or the previous className with
 * the branchType.
 */
public String putBranchClass(String branchType, String className) {
    print(".putBranchClass() - '" + branchType + "', " + className);
    return (String)branchTypes.put(branchType, className);
}
/**
 * Creates the Branch and sets its param. The param must
 * contain the property BranchType.
 */
public Branch createBranch(Param param) {

    // Create instance
    String branchType = param.getString("BranchType");
    print(".createBranch() - branchType = " + branchType);
    String className = (String)branchTypes.get(branchType);
    Branch branch = (Branch)GenLib.createInstance(className);

    // Use instance
    branch.setParam(param);

    return branch;
}
public void removeAll() {
    branchTypes.clear();
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("BranchFactory" + text);
}

} // End class
