package org.jcon.param.edtree;

import org.jcon.param.Param;
import org.jcon.param.ParamAccessor;
import org.jcon.param.ParamStoreResource;
import org.jcon.param.ParamTest;
import org.jcon.param.tree.PropList;
import org.jcon.param.tree.PropListConverter;
import org.jcon.ui.OutputConsole;
import org.jcon.ui.VisualLib;
import org.jcon.ui.WindowMgr;
import org.jcon.util.GenLib;
import java.awt.Color;
import javax.swing.JFrame;

/**
 * This class runs the ParamTree unit test. Since ParamTree
 * has a component that needs a window, we provide one.
 *
 * @author Jack Harich
 */   // java org.jcon.param.edtree.ParamTreeTest
public class ParamTreeTest {

//---------- Private Fields ------------------------------
private JFrame    frame;
private ParamTree paramTree;

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new OutputConsole().setVisible(true);
    new ParamTreeTest().start();
}
//---------- Public Methods ------------------------------
public void start() {
    print(".start() - Starting test");
    VisualLib.installLookAndFeel();
    // frame prep
    frame = new JFrame("Edit Param Tree - Unit Test");
    WindowMgr.registerFrame(frame);
    frame.setSize(360, 600);
    frame.setBackground(Color.lightGray);
    frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    
    // Create the test Param
    Param param = new ParamStoreResource().createParam(
    	"gov.cdc.atsdr.client.DataClient",
    	"EditEmployees.parex");
    
    /* ParamAccessor accessor = new ParamAccessor();
    //accessor.setMarkerClass(new ParamTest());
    //accessor.setResourceName("ParamTest.parex");
    accessor.setMarkerClass(GenLib.createInstance("gov.cdc.atsdr.client.DataClient"));
    // *** Bug - Large param fails, shows only root
    //accessor.setResourceName("awards/edit/EditAwards.parex");    
    accessor.setResourceName("EditEmployees.parex");    
    //accessor.setResourceName("awards/edit/EditAwardType.parex");    

    Param param = new ParamStoreResource().readParam(accessor);    
    */
//print(" - param = " + param);    
    
    // Contents of frame is a ParamTree
    paramTree = new ParamTree();
    paramTree.setEditParam(param);
    frame.getContentPane().add("Center", paramTree.getComponent());
    
    // Done
    frame.setVisible(true);
    
    //testHugeParam();
}
//---------- Private Methods -----------------------------
private void testHugeParam() {
    // Create param
    ParamAccessor accessor = new ParamAccessor();
    accessor.setMarkerClass(GenLib.createInstance("gov.cdc.atsdr.client.DataClient"));
    accessor.setResourceName("awards/edit/EditAwards.parex");    
    Param param = new ParamStoreResource().readParam(accessor);    
    // To PropList, ie root Datum
    PropList propList = PropListConverter.toPropList(param);
    // Back to Param
    param = PropListConverter.toParam(propList);
    // Show
    print(" - Huge recycled param is: \n" + param);
    print(" - Huge recycled param is null: " +
        (param == null ? "true" : "false") );
}
//--- Std
private static void print(String text) {
    System.out.println("ParamTreeTest" + text);
}

} // End class
