package org.jcon.param.edtree;

import org.jcon.param.Param;
import org.jcon.param.tree.PropList;
import org.jcon.param.tree.PropListConverter;
import java.awt.Component;

/**
 * This class is a fascade for a Component that allows the
 * visual display and edit of a Param in a tree. Internally
 * it changes the Param into a PropList and displays
 * the PropList's root node in a tree.
 *
 * @author Jack Harich
 */
public class ParamTree {

//---------- Private Fields ------------------------------
private DatumTreeLogic datumTreeLogic = new DatumTreeLogic();
private PropList rootPropList;

//---------- Properties ----------------------------------
public void setEditParam(Param param) {
    this.rootPropList = rootPropList;
    PropList propList = PropListConverter.toPropList(param);
    datumTreeLogic.setRootDatum(propList);
}
public Param getEditParam() {
    return PropListConverter.toParam(rootPropList);
}
public Component getComponent() {
    return datumTreeLogic.getComponent();
}
//---------- Public Methods ------------------------------

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ParamTree" + text);
}

} // End class
