package org.jcon.param.edtree;

import org.jcon.param.tree.Datum;
import org.jcon.param.tree.PropList;
import org.jcon.param.tree.PropListConverter;
import org.jcon.param.tree.TestTreeData;
import org.jcon.ui.tree.BTree;
import org.jcon.ui.WindowMgr;
import java.awt.Color;
import java.awt.event.*;
import javax.swing.*;
// java org.jcon.param.edit.View

// MOD to be just panel, so can put in ParamEditor
/**
 * The VIEW presents the Param tree on the left and the
 * selected branch on the right. It also provides popups.
 *
 * @author Jack Harich
 */
public class EditorView implements MouseListener {

//---------- Private Fields ------------------------------
private BTree      treePanel;
private JFrame     frame;

private Datum      rootDatum;
private Editor     controller;
private JPopupMenu popup;

//---------- Initialization ------------------------------
public void init() {
    // frame prep
    frame = new JFrame("Edit Param");
    frame.setSize(360, 400);
    WindowMgr.registerFrame(frame);
    frame.setBackground(Color.lightGray);
    frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

    // JTree prep. Must setRootNode first.
    treePanel = new BTree();
    treePanel.setRootNode(rootDatum.getNode());
    treePanel.setEditable(true);
    treePanel.addMouseListener(this);
    treePanel.addPopup(popup);
    frame.getContentPane().add("Center", treePanel.getComponent());
}
public static void main(String args[]) {
    new EditorView().runUnitTest();
}
//---------- MouseListener Implementation ----------------
// See org.jcon.ba.tree.TreeView for cautions on use of MouseListener
public void mouseClicked(MouseEvent evt) { }
public void mousePressed(MouseEvent evt) { }
public void mouseReleased(MouseEvent evt) {
    //print(".mouseReleased()");
    checkPopup(evt);
}
public void mouseEntered(MouseEvent evt) { }
public void mouseExited(MouseEvent evt) { }

//---------- Properties ----------------------------------
//----- Init
public void setController(Editor controller) {
    this.controller = controller;
}
public void setPopup(JPopupMenu popup) {
    this.popup = popup;
}
public void setRootDatum(Datum rootDatum) {
    this.rootDatum = rootDatum;
}
public void setVisible(boolean visible) {
    frame.setVisible(visible);
}
//----- Other
public Datum getSelectedDatum() {
    Object object = treePanel.getSelectedUserObject();
    print(".getSelectedDatum() object = " + object);
    System.out.println("   class = " + object.getClass().getName());

    return (Datum)treePanel.getSelectedUserObject();
}
//---------- Public Methods ------------------------------
public void openChildren() {
    treePanel.openChildren();
}
public void openBranch() {
    treePanel.openBranch();
}
public void runUnitTest() {

    // Create root
    PropList propList = PropListConverter.toPropList(
        TestTreeData.createHarichFamilyParam());
    propList.setName("HarichFamily"); // Or "Root"
    setRootDatum(propList);

    // Other
    init();
    setVisible(true);
    print(".runUnitTest() - Done");
}
//---------- Private Methods -----------------------------
private void checkPopup(MouseEvent evt) {
    if (! treePanel.rowIsBeneathMouse(evt)) return;

    if (evt.isPopupTrigger()) {
        Datum datum = getSelectedDatum();
        if (controller != null) controller
            .configPopup(datum);
        treePanel.showPopup(popup, evt);
    }
}
//--- Std
private static void print(String text) {
    System.out.println("EditorView" + text);
}

} // End class
