package org.jcon.param.edtree;

import org.jcon.param.tree.Datum;
import org.jcon.param.tree.PropList;
import org.jcon.param.tree.Attribute;
import org.jcon.ui.JPopupMenuHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;

/**
 * Manages the editor menus, particularly popups.
 *
 * @author Jack Harich
 */
public class EditorMenuMgr implements ActionListener {

//---------- Private Fields ------------------------------
private JPopupMenuHelper popupHelper = new JPopupMenuHelper();
private Editor           controller;

//---------- Initialization ------------------------------
public EditorMenuMgr() {
    initPopup();
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    print(".actionPerformed() - command " + command);

    // Popup commands
    if (command == "AddPropList") {

    } else if (command == "AddLineList") {
    } else if (command == "AddElementList") {
    } else if (command == "AddFact") {
    } else if (command == "AddComment") {
    } else if (command == "AddLine") {
    //-----
    } else if (command == "Delete") {
    } else if (command == "Cut") {
    } else if (command == "Copy") {
    } else if (command == "Paste") {
    //-----
    } else if (command == "MoveUp") {
    } else if (command == "MoveDown") {

    } else if (command == "OpenChildren") {
        controller.openChildren();

    } else if (command == "OpenBranch") {
        controller.openBranch();
    }
}
private void initPopup() {

popupHelper.setActionListener(this);

//----- Add menu
popupHelper.addMenu("Add",  "Add");

popupHelper.addItemToMenu("Prop List *",    "AddPropList", "Add");
popupHelper.addItemToMenu("Line List *",    "AddLineList", "Add");
popupHelper.addItemToMenu("Element List *", "AddElementList", "Add");
popupHelper.addSeparatorToMenu("Add");

popupHelper.addItemToMenu("Fact *",    "AddFact", "Add");
popupHelper.addItemToMenu("Comment *", "AddComment", "Add");
popupHelper.addItemToMenu("Line *",    "AddLine", "Add");

//----- Items
popupHelper.addSeparator();
popupHelper.addItem("Delete *", "Delete");
popupHelper.addItem("Cut *",    "Cut");
popupHelper.addItem("Copy *",   "Copy");
popupHelper.addItem("Paste *",  "Paste");

popupHelper.addSeparator();
popupHelper.addItem("Move Up *",     "MoveUp");
popupHelper.addItem("Move Down *",   "MoveDown");
popupHelper.addItem("Open Children", "OpenChildren");
popupHelper.addItem("Open Branch",   "OpenBranch");

} // End method

//---------- Properties ----------------------------------
public void setController(Editor controller) {
    this.controller = controller;
}
public JPopupMenu getPopup() {
    return popupHelper.getPopup();
}
//---------- Public Methods ------------------------------
public void configPopup(Datum datum) {

    if (datum instanceof PropList) {
        popupHelper.setEnabledMenu("Add", true);

        popupHelper.setEnabled("AddPropList", true);
        popupHelper.setEnabled("AddLineList", true);
        popupHelper.setEnabled("AddElementList", true);

        popupHelper.setEnabled("AddFact", true);
        popupHelper.setEnabled("AddComment", true);
        popupHelper.setEnabled("AddLine", false);

    } else if (datum instanceof Attribute) {
        popupHelper.setEnabledMenu("Add", false);

    } else {
        print("Datum type " + datum.getClass().getName() + " not implemented");
    }
    if (datum.isLeaf()) {
        popupHelper.setEnabled("OpenChildren", false);
        popupHelper.setEnabled("OpenBranch", false);
    } else {
        popupHelper.setEnabled("OpenChildren", true);
        popupHelper.setEnabled("OpenBranch", true);
    }
}
//---------- Private Methods -----------------------------

//--- Std
private static void print(String text) {
    System.out.println("EditorMenuMgr" + text);
}

} // End class
