package org.jcon.param.edtree;

import org.jcon.param.tree.Datum;
import org.jcon.param.tree.PropList;
import org.jcon.param.tree.PropListConverter;
import org.jcon.param.tree.TestTreeData;
import org.jcon.param.Param;
import org.jcon.ui.JPopupMenuHelper;
import org.jcon.ui.VisualLib;

/**
 * Allows the user to visually edit a Param. The CONTROLLER.
 *
 * @author Jack Harich
 */
public class Editor { // java org.jcon.param.edtree.Editor

//---------- Private Fields ------------------------------
private EditorView    view = new EditorView();
private EditorMenuMgr menuMgr = new EditorMenuMgr();
private Param         param;

//---------- Initialization ------------------------------
public Editor() {
    print(" - Constructor - Entered");
    view.setController(this);
    menuMgr.setController(this);
    view.setPopup(menuMgr.getPopup());
}
public static void main(String args[]) {
    Editor.runUnitTest();
}
//---------- Public Methods ------------------------------
public void setParam(Param param) {
    this.param = param;
    PropList propList = PropListConverter.toPropList(param);
    propList.setName("Root");
    view.setRootDatum(propList);
    view.init();
}
public void setVisible(boolean visible) {
    view.setVisible(visible);
}
public void configPopup(Datum datum) {
    menuMgr.configPopup(datum);
}
public static void runUnitTest() {
    // Simulate application prep
    print(".runUnitTest() - Entered");
    VisualLib.installLookAndFeel();
    Editor editor = new Editor();

    // Create and set root
    editor.setParam(TestTreeData.createHarichFamilyParam());

    // Other
    editor.setVisible(true);
    print(".runUnitTest() - Done");
}
//----- menuMgr commands
public void openChildren() {
    view.openChildren();
}
public void openBranch() {
    view.openBranch();
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("Editor" + text);
}

} // End class
