package org.jcon.param.edtree;

import org.jcon.param.tree.Attribute;
import org.jcon.param.tree.Datum;
import org.jcon.param.tree.PropList;
import org.jcon.ui.tree.BTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * This class manages the VIEW of the Datum tree, This includes
 * display, context menu and tree mutation.
 *
 * @author Jack Harich
 */
public class DatumTreeView implements ActionListener {

//---------- Private Fields ------------------------------
// Properties
private PropList   rootPropList;
// Internal
private BTree treePanel = new BTree();

//---------- Initialization ------------------------------
public DatumTreeView() {
    treePanel.setActionListener(this);  
    //treePanel.setCellEditor(new CellEditor(treePanel));  
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    print(" - command = " + command);
    if (command == "ValueChanged") {
        //print(" - new value is '" + treePanel.getNodeText() + "'");
        // Fake validation failure
        //treePanel.setNodeText("Failure"); // FAILS
        //treePanel.repaint(); // *** No effect
        //treePanel.refresh(); // Causes exception
        //treePanel.nodeChanged(treePanel.getSelectedNode());
        //print(" - Selected node = " + 
            //treePanel.getSelectedNode().toString());
            
        Datum datum = (Datum)treePanel.getSelectedNode().getUserObject();
        if (datum instanceof Attribute) {
            Attribute att = (Attribute)datum;
            att.setValue("TEST");
            treePanel.currentNodeChanged();
        }    
    }
}
//---------- Properties ----------------------------------
public void setRootDatum(PropList rootPropList) {
    rootPropList.setName("Root");
    treePanel.setRootNode(rootPropList.getNode());
    treePanel.setEditable(true); // <------<<<
}
public Component getComponent() {
    return treePanel.getComponent();
}
public Datum getSelectedDatum() {
    // This block for testing
    Object object = treePanel.getSelectedUserObject();
    print(".getSelectedDatum() object = " + object);
    System.out.println("   class = " + object.getClass().getName());

    return (Datum)treePanel.getSelectedUserObject();
}
//---------- Public Methods ------------------------------

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("DatumTreeView" + text);
}

} // End class
