package org.jcon.param;

import org.jcon.util.GenLib;

/**
 * Various tests.  java org.jcon.param.ParamTest
 *
 * @author Jack Harich
 */

public class ParamTest {

//---------- Private Fields ------------------------------
// (none)

//---------- Initialization ------------------------------
public ParamTest() {
    // No arg to allow reuse of ParamText.parex
}
public ParamTest(String args[]) {
    //testConverterToString();
    //print("");

    //testConverterToParam();
    //print("");
    ParamAccessor accessor = new ParamAccessor();
    accessor.setMarkerClass(this);
    accessor.setResourceName("ParamTest.parex");
    Param param =
        new ParamStoreResource().readParam(accessor);
    ParamConverter.buildText(param);        
    print("Tested - ParamStoreResource.readParam()\n" + param);
    print("");

    //testPathParam();

    //GenLib.readInputLine("Test complete: ");
}
public static void main(String args[]) {
    new ParamTest(args);
}
//---------- Public Methods ------------------------------
public void testConverterToString() {
    print("Test - Converter.toString()");
    print(ParamConverter.toString(getTestParam()));
}
public void testConverterToParam() {
    print("Test - Converter.toParam()");
    // Create a String with parameters
    String text = getTestParam().toString();
    // Convert String to Param
    Param param = ParamConverter.toParam(text);
    // Show results
    print("Size = " + param.getString("Size"));
    print("Column 2 = " + param.getParam("Columns").getString("2"));
    print("getString('Columns.3.Width') = " +
        //param.getParam("Columns").getParam("3").getString("Width"));
       param.getString("Columns.3.Width"));
}
//---------- Private Methods -----------------------------
// Note //1 and //2 are required to simulate from text
private Param getTestParam() {
    Param p1 = new Param();
    p1.put("Title", "Edit Customers");
    p1.put("Size", "200, 300");
    p1.put("//1", " How about those beautiful columns...");

        Param p2 = new Param();
        p1.put("Columns", p2);
        p2.put("1", "Code, 6");
        p2.put("2", "Customer, 35, CustName");

            Param p3 = new Param();
            p2.put("3", p3);
            p3.put("Title", "Remarks");
            p3.put("Width", "50");
            p3.put("Movable", "false");

    p1.put("//2", ""); // White space
    p1.put("Age", "46");
    return p1;
}
private void testPathParam() {
    Param p = new Param();
    p.put("Title", "Fancy title");
    p.put("//1", " This is a comment");
    p.put("Columns.1", "Code, 22, 35");
    p.put("Columns.2", "Cust, 322");
    p.put("Columns.3.Title", "Another title");
    p.put("Columns.3.Width", "22");
    p.put("Columns.3.Movable", "false");
    p.put("//2", "");
    p.put("Last", "But not least");
    p.buildText();

    print("testPathParam() is:\n" + p);
    print("Columns.3.Width is " + p.getString("Columns.3.Width") );
}
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
