package org.jcon.param;


/**
 * Defines the Param persistence interface, allowing a
 * plug point for the preferred storage mechanism.
 *
 * @author Jack Harich
 */
public interface ParamStore {
    
//---------- Public Methods ------------------------------
/**
 * The file extension used for text files containing the
 * String representation of a Param is "parex".
 * "parex" means Parameter Text file. The constant SUFFIX
 * contains ".parex".
 */
// not used public static final String SUFFIX = ".parex";

/**
 * Creates and returns a Param using the ParamAccessor.
 */
public Param readParam(ParamAccessor accessor);

/**
 * Writes the param using its ParamAccessor data. If newText
 * is not null then the param is written with the newText
 * and the param is updated with the newText if successful.
 * Returns true for success, false for failure.
 *
 * Note the param contains the same ParamAccessor used to
 * create it. This should be used for the write.
 */
public boolean writeParam(Param param, String newText);


} // End interface
