package org.jcon.param;

/**
 * This interface signifies a class prefers to delay Param
 * creation. It.is an alternative to ParamDriven. Classes
 * with large Params or in a basket with many Params
 * should implement this interface instead of ParamDriven.
 * <p>
 * The correct use of this interface greatly speeds up
 * running BA systems.
 * <p>
 * The class should implement getParam() as follows: <pre>
 *      public Param getParam() {
 *          if (param == null) {
 *              paramSupplier.supplyParam(this);
 *              paramSupplier = null;
 *          }
 *          return param;
 *      } 
 * </pre>
 * When the class internally needs its Param it should call
 * getParam(). This will behave correctly. See 
 * org.jcon.df.edit.DataEditor for an example.
 *
 * @author Jack Harich
 */
public interface ParamDrivenSupply extends ParamDriven {

/**
 * Sets the ParamSupplier, which is later used to create
 * the Param when the class needs it.
 */
public void setParamSupplier(ParamSupplier paramSupplier);

} // End interface
