package org.jcon.param;

public interface ParamDriven {

/**
 * Indicates a class is Param driven, and sure would like
 * its Param set so it can get happily to work. Additional
 * methods are for use in builder tools, such as the BA.
 *
 * See org.jcon.ba.system.Item for additional method documentation.
 *
 * @author Jack Harich
 */

/**
* Sets the Param to be used to initialize the instance.
* This will only be called once. To reset the Param we use
* applyNewParam().
*
* @param param  the parameter driven data structure.
*/
public void setParam(Param param);

/**
* Gets the Param that is currently in effect or null if none.
* This is used for editing and then applying to the instance.
*
* @return  the current Param.
*/
public Param getParam();

/**
* The instance should apply the new Param to itself.
* This can be as simple as complete reinitialzation or as
* robust as internally changing only what has changed in
* the new versus old Param.
*
* @param  newParam   the new Param to apply.
* @return            true for success or false for failure.
*/
public boolean applyNewParam(Param newParam);

/**
* Gets the metadata for this ParamDriven instance.
* This is for FUTURE USE, so return null for now.
*
* @return  null or the metadata for this instance.
*/
public ParamDrivenInfo getParamDrivenInfo();


} // End interface


/**

import org.jcon.param.Param;
import org.jcon.param.ParamDriven;
import org.jcon.param.ParamDrivenInfo;

private Param param;

//---------- ParamDriven Implementation ------------------
public void setParam(Param param) {
    this.param = param;
}
public Param getParam() {
    return param; 
}
public boolean applyNewParam(Param newParam) {
    // Lots of work perhaps
    // Sometimes - setParam(newParam);
    return true; // Successful
}
public ParamDrivenInfo getParamDrivenInfo() {
    return null;
}

*/