package org.jcon.param;

import org.jcon.util.GenLib;
import java.io.Serializable;

/**
 * Carries data used to access (read or write) a Param.
 * We expect to add more properties or allow custom
 * use via a PropMap or such. Or this may become a plugpoint
 * interface.
 *
 * @author Jack Harich
 */
public class ParamAccessor implements Serializable {

//---------- Private Fields ------------------------------
private transient Object markerClass;
private String resourceName;

//---------- Initialization ------------------------------
public ParamAccessor() {
}
public ParamAccessor(Object markerClass, String resourceName) {
    this.markerClass = markerClass;
    this.resourceName = resourceName;    
}   
public ParamAccessor(String markerClassName, String resourceName) {
    markerClass = GenLib.createInstance(markerClassName);
    this.resourceName = resourceName;
} 
//---------- Superclass Overrides ------------------------
public Object clone() {
    ParamAccessor accessor = new ParamAccessor();
    accessor.markerClass = markerClass;
    accessor.resourceName = resourceName;
    return accessor;
}
public String toString() {
    return "[markerClass=" + markerClass + ", resourceName=" + resourceName + "]";
}
//---------- Properties ----------------------------------
//----- markerClass
/**
 * Sets the class instance used as the marker when
 * referring to the relative ResourceName.
 *
 * For a fuller understanding see java.class.getResourceAsStream().
 * That method uses the concept of a marker class and a
 * relative resource name.
 *
 * In the case of the BA the marker class is either the
 * root marker class or the marker class of a branch that
 * is being reused. In the latter case the ResourceName
 * is relative to the branch root.
 */
public void setMarkerClass(Object markerClass) {
    this.markerClass = markerClass;
}
public Object getMarkerClass() {
    return markerClass;
}
//----- resourceName
/**
 * Sets the relative ResourceName. This is the file name
 * and type, plus an optional prefix containing the path.
 * Examples: "_module.parex", "tree/menu/PopupMenu.parex"
 * The path separator should be platform independent,
 * though I suspect that "/" is handled correctly. (???)
 */
public void setResourceName(String resourceName) {
       this.resourceName = resourceName;
}
public String getResourceName() {
    return resourceName;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ParamAccessor" + text);
}

} // End class
