package org.jcon.msg;

import java.io.Serializable;
import java.util.Enumeration;

/**
* This interface contains the MessageDefs that a
* MessageSource can send. Note the similarity to
* MessageListenerInfo. We expect this interface to 
* evolve by adding more methods, such as which MessageDefs
* must be caught for the source to work properly.
* 
* @author Jack Harich 
*/
public interface MessageSourceInfo extends Serializable {

/**
* Sets a MessageDef by adding it to the MessageDefs for
* this instance. Each MessageDef must have a unique 
* Message name. Duplicates will cause an exception, since
* this is probably a programming error.
*
* @param def  the MessageDef to set.
*/
public void setMessageDef(MessageDef def);

/**
* Returns all the MessageNames the source can send.
*
* @return an Enumeration of zero or more String names.
*/
public Enumeration getMessageNames();

/**
* Returns the MessageDef for the messageName.
*
* @param messageName  the Message name of interest.
* @return the desired MessageDef or null if not found.
*/
public MessageDef getMessageDef(String messageName);

/**
* Returns all the MessageDefs.
*
* @return an Enumeration of zero or more MessageDefs.
*/
public Enumeration getMessageDefs();

}