package org.jcon.msg;

import java.io.Serializable;
import java.util.Enumeration;

/**
* This interface contains the MessageDefs that a
* MessageListener is interested in. Note the similarity to
* MessageSourceInfo. We expect this interface to 
* evolve by adding more methods, such as which MessageDefs
* must be processed for the listener to work properly.
* 
* @author Jack Harich 
*/
public interface MessageListenerInfo extends Serializable {

/**
* Sets a MessageDef by adding it to the MessageDefs for
* this instance. Each MessageDef must have a unique 
* Message name. Duplicates will cause an exception, since
* this is probably a programming error.
*
* @param def  the MessageDef to set.
*/
public void setMessageDef(MessageDef def);

/**
* Returns all the MessageNames the listener is interested in.
*
* @return an Enumeration of zero or more String names.
*/
public Enumeration getMessageNames();

/**
* Returns the MessageDef for the messageName.
*
* @param messageName  the Message name of interest.
* @return the desired MessageDef or null if not found.
*/
public MessageDef getMessageDef(String messageName);

/**
* Returns all the MessageDefs.
*
* @return an Enumeration of zero or more MessageDefs.
*/
public Enumeration getMessageDefs();

}