package org.jcon.msg;

import java.io.Serializable;

/**
* This interface defines a single MessageDef property. This
* is mostly for understandability purposes.
* 
* @author Jack Harich 
*/
public interface MessageDefProperty extends Serializable {

/**
* Sets the property name, such as "Name" or "FileName".
* This should be unique per Message.
*
* @param name  the name of the property.
*/
public void setName(String name);

/**
* Returns the property name.
*
* @return the name of the property.
*/
public String getName();

/**
* Sets the class type of the property.
*
* @param type  the type.
*/
public void setType(Class type);

/**
* Returns the type of the property.
*
* @return the property type.
*/
public Class getType();

/**
* Sets a short description of the property, such as
* "Menu item name" or "Background color in hex". This
* should be a max of about 40 characters. (See Inspector???)
*
* @param shortDescription  the short description.
*/
public void setShortDescription(String shortDescription);

/**
* Returns the short description.
*
* @return the short description.
*/
public String getShortDescription();

// Optional
/**
* Sets the long descrioption of the property. This can be
* several paragraphs long, and is optional.
*
* @param longDescription  the long descriptive text.
*/
public void setLongDescription(String longDescription);

/**
* Returns the long description.
*
* @return the long descriptive text.
*/
public String getLongDescription();


}