package org.jcon.msg;

import java.io.Serializable;
import java.util.Enumeration;

/**
* This interface defines the structure of a Message, which
* is its name and MessagePropertyDefs. MessageSources
* should honor these definitions, and MessageListeners can
* rely on them.
* 
* @author Jack Harich 
*/
public interface MessageDef extends Serializable {

/**
* Sets the Message name.
*
* @param messageName  the name of the Message.
*/
public void setMessageName(String messageName);

/**
* Returns the Message name.
*
* @return the name of the Message.
*/
public String getMessageName();

/**
* Sets the definition for a Message property. Each should
* have a unique property name.
*
* @param property  the property definition.
*/
public void setProperty(MessageDefProperty property);

/**
* This is a convenience method that is the same as
* setProperty(property) where the property argument
* contains a name, type and shortDescription.
*
* @param propertyName  the property name.
* @param type          the property class type.
* @param shortDescription  the short description.
*/
public void setProperty(String propertyName, Class type, String shortDescription);

/**
* Removes the property with propertyName. There is no
* effect if not found.
*
* @param propertyName  the name of the property to remove.
* @return the property removed or null if none.
*/
public MessageDefProperty removeProperty(String propertyName);

/**
* Returns all the property names.
*
* @return an Enumeration of zero or more String names.
*/
public Enumeration getPropertyNames();

/**
* Returns a particular property or null if not found.
* 
* @param propertyName  the name of the desired property.
* @return the desired property or null if not found.
*/
public MessageDefProperty getProperty(String propertyName);

/**
* Returns all the properties.
*
* @return an Enumeration of zero or more MessageDefProperties.
*/
public Enumeration getProperties();

}