package org.jcon.msg;

import org.jcon.util.PropMap;
import java.io.Serializable;

/**
* This interface is a named Datatron for use in sending
* Datatrons between clients such as parts. In practice
* a Message is usually used as an event object sent from
* a MessageSource to MessageRouter to MessageListeners.
* <p>
* Note messageName must be unique for all using the same
* event router. When coding messageNames ALWAYS copy and 
* paste messageName from the source.
* <p>
* Due to String interning, do NOT use new String("Name")
* to create messageNames. This will cause Hashtable to fail.
* <p>
* This doesn't extend EventObject so there is no event source.
* This is deliberate, since if the event listener uses the
* source for anything tight coupling is introduced. If the
* need arises to pass the source, use a property or change
* the design.
* <p>
* The Message name and isAcquire are immutable and are set
* via constructors.
* 
* @author Jack Harich 
*/
public interface Message extends PropMap, Cloneable, Serializable {

// Additional methods not in PropMap are:

/**
* Returns the Message name, which is immutable. It serves
* to uniquely identify the Message in the Message namespace.
*
* @return the Message name, which is never null.
*/
public String getName(); 

/**
* Determines if this is an "acquire" type of Message.
* If it is then "acquire" properties are mutable.
*
* @return true if an "acquire" Message, false if not.
*/
// Future use - public boolean isAcquire(); // If true acquire properties can be set
// May change to something like:
// public MessageInfo getMessageInfo()

/**
* Returns a shallow clone of the Message with the provided
* messageName. This is used to change the messageName and
* create a new Message at the same time. This is useful
* things such as automatic Message translation.
*/
public Object clone(String messageName);

}