package org.jcon.io;

import org.jcon.util.GenLib;

/**
 * Validates that a file is a certain type, such as a class.
 *
 * @author Jack Harich
 */
public class FileValidator {

//---------- Public Fields -------------------------------
// Use Strings to allow easy parameter setting
public static final String FILE  = "File";
public static final String CLASS = "Class";

//---------- Private Fields ------------------------------
private String fileType = FILE;
private String messageName;

//---------- Properties ----------------------------------
//----- fileType
/**
 * Sets the validation type, which may be FILE or CLASS.
 * FILE has no validation, CLASS tests that the file is
 * a valid Java class by attempting Class.forName(). This
 * means the class file cannot be an interface.
 * The default is FILE, the most common.
 */
public void setFileType(String fileType) {
    this.fileType = fileType;
}
public String getFileType() {
    return fileType;
}
//---------- Events --------------------------------------
//---------- Public Methods ------------------------------
public boolean validate(String dirName, String fileName) {
    if (fileType == FILE) {
        // *** Need to test if FileDialog tests this, assume it does
        messageName = dirName + fileName;
        return true;
    } else {
        // Class
        Class test = ResourceLib.getFileClass(dirName, fileName);
        if (test == null) {
            GenLib.helpfulHint("Whoops, the file '" +
                dirName + fileName + "' is not a Java class.");
            return false;
        } else {
            messageName = test.getName();
            return true;
        }
    }
}
/**
 * Returns the name of a Message, which should
 * contain the complete file content. For example if just
 * a FILE type, then return dir + file name. If a CLASS
 * type then return the class name.
 */
public String getMessageName() {
    return messageName;
}

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
