package org.jcon.inspect;

import org.jcon.util.GenLib;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageDef;
import org.jcon.util.msg.MessageListener;
import org.jcon.util.msg.MessageSourceStd;
import java.awt.Point;
import java.util.Vector;

/**
 * A bean with various members and interfaces for testing.
 *
 * @author Jack Harich
 */
public class TestBean extends MessageSourceStd
    implements MessageListener {

//---------- Private Fields ------------------------------
private String  name = "My Name";
private int     age  = 48;
private boolean funLover = true;

public TestBean() {
    messageRouter.addListener("ThatHappened", this);
}
//---------- MessageSourceStd Abstractions ---------------
public Vector getMessageDefs() {
    Vector defs = new Vector();
    MessageDef def;

    def = new MessageDef("AddIcon", this);
    def.add("Name", String.class, "Name of icon.");
    def.add("Point", Point.class, "Location to add icon.");
    defs.addElement(def);

    def = new MessageDef("StartTest", this);
    defs.addElement(def);

    def = new MessageDef("SetStatusText", this);
    def.add("Text", String.class, "Text to display in status bar.");
    defs.addElement(def);

    return defs;
}
//---------- MessageListener Implementation --------------
public void processMessage(Message message) {
    String messageName = message.getName();

    if (messageName == "ThisHappened") {
        print(" - " + messageName);
    } else if(messageName == "ThatHappened") {
        print(" - " + messageName);
    } else {
        print(".processMessage() - Unknown messageName '" + messageName + "'");
    }
}
public String[] loadMessageInterests() {
    return new String[] {"ThisHappened", "ThatHappened"};
}
//---------- Properties ----------------------------------
//----- name Pair
public void setName(String name) {
    this.name = name;
    print(" - Name changed to '" + name + "'");
}
public String getName() {
    print(" - Returned name '" + name + "'");
    return name;
}
//----- age Pair
public void setAge(int age) {
    this.age = age;
    print(" - Age changed to '" + age + "'");
}
public int getAge() {
    return age;
}
//----- funLover Pair
public void setFunLover(boolean funLover) {
    this.funLover = funLover;
    print(" - FunLover changed to '" + funLover + "'");
}
public boolean isFunLover() {
    return funLover;
}
//----- String[] pait
public String[] getStringArray() {
    String[] text = { "asdf", "zzzz" } ;
    return text;
}
public void setStringArray(String[] values) {
    // Do nothing
}
//---------- Public Methods ------------------------------
public boolean runUnitTest(String option) {
    GenLib.helpfulHint("Unit test '" + option + "' run successfully.");
    return true;
}
public void doThis(String value, boolean two) {
    print(".doThis() called, value = '" + value + "'");
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TestBean" + text);
}

} // End class
