package org.jcon.inspect;

import org.jcon.util.Hub;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageRouter;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;

/**
 * The property sheet VIEW. Fires events to router.
 *
 * @author Jack Harich
 */
public class PropertySheetView implements
        MouseListener, KeyListener {

//---------- Private Fields ------------------------------
private Hub               hub;
private MessageRouter     router;
private MyTableModel tableModel = new MyTableModel();
private JTable            table = new JTable(tableModel);
private JScrollPane       tableScrollpane = new JScrollPane(table);
private Vector rows = new Vector();

//---------- Initialization ------------------------------
public PropertySheetView() {
    // Prepare table *** Exact Col widths LATER
    tableModel.addColumn("Property");
    tableModel.addColumn("Value");

    table.addMouseListener(this);
    table.addKeyListener(this);
    table.setBackground(Color.lightGray);
    table.setAutoCreateColumnsFromModel(false);
}
//---------- MouseListener Implementation ----------------
public void mouseClicked(MouseEvent evt) {
    if (evt.getSource() != table) return;

    // KLUDGE since KeyEvent not possible in table
    if (evt.getClickCount() == 1) {
        copySelectedPropertyToClipboard();

    } else if (evt.getClickCount() == 2) {
        // Double click - Fire ExploreProperty event
        int rowIndex = table.getSelectedRow();
        Message message = new Message("ExploreProperty");
        message.set("Property", rows.elementAt(rowIndex));
        router.fire(message, this);
    }
}
public void mousePressed(MouseEvent evt) { }
public void mouseReleased(MouseEvent evt) { }
public void mouseEntered(MouseEvent evt) { }
public void mouseExited(MouseEvent evt) { }

//---------- KeyListener Implementation ------------------
public void keyTyped(KeyEvent evt) { }
public void keyReleased(KeyEvent evt) { }
public void keyPressed(KeyEvent evt) {

// *** Problem - Table never gets focus, cannot receive event
print(".keyPressed()");
    // Allow copy with Ctrl Shift C
    if (evt.isControlDown() == false) return;
    if (evt.isShiftDown() == false) return;
    if (evt.getKeyCode() != KeyEvent.VK_C) return;
}
//---------- Public Methods ------------------------------
public void setHub(Hub hub) {
    this.hub = hub;
    router = hub.getRouter();
}
public JComponent getComponent() {
    return tableScrollpane;
}
public void emptyProperties() {
    while (tableModel.getRowCount() > 0) {
        tableModel.removeRow(0);
    }
    rows.removeAllElements();
}
public void addProperty(BeanProperty property) {
    String name = property.getPropertyName() + "  " +
        property.getTypeName();
    Object value = property.getValue();
    String valueString = (value == null ? "(null)" : value.toString() );
    String[] row = { " " + name, " " + valueString }; // Get CellRenderer to pad
    //print(" adding row - " + row);
    tableModel.addRow(row);
    rows.addElement(property);
}
//---------- Private Methods -----------------------------
private void copySelectedPropertyToClipboard() {
    int rowIndex = table.getSelectedRow();
    if (rowIndex < 0) return;

    // Copy to clipboard
    BeanProperty prop = (BeanProperty)rows.elementAt(rowIndex);
    Object value = prop.getValue();
    if (value == null) return;
    Class  type  = prop.getType();
    InspectClipboard.postMethodArgument(hub, value, type);
}
//--- Std
private static void print(String text) {
    System.out.println("PropertySheetView" + text);
}
//========== Inner Classes ===============================
// Implemented solely because there is no property setEditable(false)
// This is poor design
class MyTableModel extends DefaultTableModel {
    // ----- Superclass Overrides -----
    public boolean isCellEditable(int row, int col) {
        return false;
    }

} // End inner class

} // End outer class
