package org.jcon.inspect;

import org.jcon.util.Hub;
import org.jcon.util.GenLib;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageRouter;
import java.util.Vector;

/**
 * Explores properties by drilling down and returning.
 *
 * @author Jack Harich
 */
public class PropertyExplorer {

//---------- Private Fields ------------------------------
private MessageRouter router;
private Inspector inspector;

// For explore and return
private Vector pathObjects = new Vector();

//---------- Initialization ------------------------------
// (none)

//---------- Public Methods ------------------------------
public void setHub(Hub hub) {
    router = hub.getRouter();
}
public void setInspector(Inspector inspector) {
    this.inspector = inspector;
}
public void explore(BeanProperty property) {
    // Cannot explore primitive. They are a leaf.
    if (property.isPrimitive() || property.isArray() ) {
        GenLib.beep();
        return;
    }
    // Add current instance to path for return
    PathObject pathObject = new PathObject(
        inspector.getInstance(), inspector.getInstanceName() );
    pathObjects.addElement(pathObject);
    // Change to inspecting selected property
    inspector.setInstance(property.getValue(), property.getPropertyName() );
    // Enable Return button since list not empty
    updateReturnEnabled();
}
public void returnFromProperty() {
    if (pathObjects.isEmpty() ) {
        GenLib.beep(); // Should not happen if button controlled
        return;
    }
    // Get last in, remove from list
    PathObject po = (PathObject)pathObjects.lastElement();
    pathObjects.removeElementAt(pathObjects.size() - 1);
    // Revert
    inspector.setInstance(po.exploreInstance, po.exploreInstanceName);
    // Disable Return button if list empty
    updateReturnEnabled();
}
//---------- Private Methods -----------------------------
private void updateReturnEnabled() {
    // Return button enabled if pathObjects not empty
    Message message = new Message("UpdateViewReturnEnabled");
    message.setBoolean("IsEnabled", ! pathObjects.isEmpty());
    router.fire(message, this);
}
//--- Std
private static void print(String text) {
    System.out.println("PropertyExplorer" + text);
}
//========== Inner Classes ===============================
class PathObject {

    Object exploreInstance;
    String exploreInstanceName;

    PathObject(Object exploreInstance, String name) {
        this.exploreInstance = exploreInstance;
        exploreInstanceName = name;
    }

} // End inner class

} // End class
