package org.jcon.inspect;

import java.lang.reflect.Method;

/**
 * Contains data pertaining to one method row.
 *
 * @author Jack Harich
 */
class MethodRowData {

//---------- Private Fields ------------------------------
private Method method;
private MethodArgument[] arguments;

//---------- Initialization ------------------------------
MethodRowData(Method method) {
    this.method = method;
    // Populate arguments, initially with String arguments
    int numberArgs = method.getParameterTypes().length;
    arguments = new MethodArgument[numberArgs];
    for (int i = 0; i < numberArgs; i++) {
        arguments[i] = new MethodArgument("");
    }
}
//---------- Package Methods -----------------------------
Method getMethod() {
    return method;
}
MethodArgument getArgument(int index) {
    return arguments[index];
}
// For paste operations or reverting to String
void setArgument(int index, MethodArgument argument) {
    // Need to assert correct type *******
    arguments[index] = argument;
}
String getDisplayText(int index) {
    return getArgument(index).getDisplayText();
}
MethodArgument[] getArguments() {
    return arguments;
}
Class getArgType(int index) {
    Class[] types = method.getParameterTypes();
    return types[index];
}


} // End class
