package org.jcon.inspect;

import org.jcon.util.BeanLib;

/**
 * Represents one method invocation argument.
 *
 * @author Jack Harich
 */
public class MethodArgument {

//---------- Private Fields ------------------------------
private boolean isString = false;
private Object  value;
private Class   type;
private String  propertyName;
private boolean hasPropertyName = false;

//---------- Initialization ------------------------------
/**
 * For manually entered String values.
 */
public MethodArgument(String value) {
    isString = true;
    this.value = value;
    type = String.class;
}
/**
 * For method invocation return values.
 */
public MethodArgument(Object value, Class type) {
    isString = false;
    this.value = value;
    this.type = type;
}
//---------- Properties ----------------------------------
//----- value
public void setValue(Object value) {
    this.value = value;
}
public Object getValue() {
    return value;
}
//----- propertyName
public void setPropertyName(String propertyName) {
    this.propertyName = propertyName;
    hasPropertyName = true;
}
public String getPropertyName() {
    return propertyName; // null if none
}
//----- Other
public boolean isString() {
    return isString;
}
public Class getType() {
    return type;
}
public String getDisplayText() {
    if (isString) {
        return (String)value;
    } else {
        String text = BeanLib.extractFullDisplayTypeName(type);
        if (hasPropertyName) text = propertyName + "  " + text;
        text = "(" + text + ")";
        return text + "  " + value.toString();
    }
}
//---------- Public Methods ------------------------------
public boolean hasPropertyName() {
    return hasPropertyName;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("MethodArgument" + text);
}

} // End class
