package org.jcon.inspect;

import org.jcon.util.Hub;
import org.jcon.util.msg.MessageRouter;
import org.jcon.ui.VisualLib;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

import javax.swing.*;

/**
 * The message sheet VIEW. Fires events to router.
 *
 * @author Jack Harich
 */
public class MessageSheetView implements ItemListener {

//---------- Private Fields ------------------------------
private MessageSheet  messageSheet;
private Hub           hub;
private MessageRouter router;

private JPanel mainPanel = new JPanel();
private List  interestList = new List(4);
private List  signalList = new List(8);
private List  eventChainList = new List();
private List  listenerList = new List();

private Checkbox  signalPropertiesCheckbox = new Checkbox("Properties");
private TextField signalDescription = new TextField();

//---------- Initialization ------------------------------
public MessageSheetView(MessageSheet messageSheet) {
    this.messageSheet = messageSheet;

    mainPanel.setLayout(new BorderLayout());
    //----- Interests
    Panel interestPanel = new Panel();
    mainPanel.add("North", interestPanel);
    interestPanel.setLayout(new BorderLayout());

    interestPanel.add("North", createBoldAndCommentPanel(
        "Interests", "  (receives)"));
    interestPanel.add("South", interestList);

    //----- Signals
    Panel signalPanel = new Panel();
    signalPanel.setLayout(new BorderLayout());

    Panel topSignalPanel = new Panel();
    topSignalPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 2));
    signalPanel.add("North", topSignalPanel);

    topSignalPanel.add(createBoldAndCommentPanel(
        "Signals", "  (sends)"));
    topSignalPanel.add(signalPropertiesCheckbox);

    signalPanel.add("Center", signalList);
    signalPanel.add("South", signalDescription);
    signalDescription.setEditable(false);

    //----- lowTab - Message Chain, Listeners
    JTabbedPane lowTab = new JTabbedPane();
    lowTab.addTab("Message Chain", eventChainList);
    lowTab.addTab("Listeners", listenerList);

    //----- splitPane has signals and lowPanel
    JSplitPane splitPane = new JSplitPane(JSplitPane.
        VERTICAL_SPLIT, signalPanel, lowTab);
    mainPanel.add("Center", splitPane);
    mainPanel.validate();

    //----- Misc
    signalList.addItemListener(this);
    signalPropertiesCheckbox.addItemListener(this);
}
private Panel createBoldAndCommentPanel(String boldText, String commentText) {
    Panel panel = new Panel();
    panel.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
    Label boldLabel = new Label(" " + boldText);
    boldLabel.setFont(new Font("Dialog", Font.BOLD, 14));
    boldLabel.setFont(VisualLib.createBoldFont(boldLabel, true));
    panel.add(boldLabel);
    panel.add(new Label(commentText));
    return panel;
}
//---------- ItemListener Implementation -----------------
public void itemStateChanged(ItemEvent evt) {

    if (evt.getSource() == signalPropertiesCheckbox) {
        messageSheet.showSignalPropertiesChanged();

    } else if (evt.getSource() == signalList) {
        messageSheet.signalSelected(signalList
            .getSelectedIndex());
    }
}
//---------- Public Methods ------------------------------
public void setHub(Hub hub) {
    this.hub = hub;
    router = hub.getRouter();
}
public JComponent getComponent() {
    return mainPanel;
}
public void emptyData() {
    interestList.removeAll();
    emptySignalData();
    eventChainList.removeAll();
    listenerList.removeAll();
}
//----- Interests
public void addInterest(String interest) {
    interestList.add(interest);
}
//----- Signals
public void addSignal(String text) {
    signalList.add(text);
}
public void setSignalText(String text) {
    signalDescription.setText(text);
}
public boolean isShowSignalProperties() {
    return signalPropertiesCheckbox.getState();
}
public void emptySignalData() {
    signalList.removeAll();
    setSignalText(null);
}
//----- Event chain
public void emptyEventChainData() {
    eventChainList.removeAll();
}
public void addEventChainLine(String line) {
    eventChainList.add(line);
}
//----- Listeners
public void addListener(String listener) {
    listenerList.addItem(listener);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("MessageSheetView" + text);
}

} // End class