package org.jcon.inspect;

import java.util.Vector;

/**
 * The interface for an Inspector controller. These can be
 * zero or one controller per Inspector. This is a far
 * cleaner and concise approach than events and listeners.
 *
 * The Inspector will call these controller methods when
 * the related event occurs.
 *
 * @author Jack Harich
 */
public interface InspectorController {

/**
 * Called when the user attempts to manually close the
 * window.
 */
public void inspectorClosingRequested(Inspector inspector);

/**
 * Called when the MessageChain for a signal is needed.
 * The Vector returned should contain the Strings
 * representing the chain steps.
 */
public Vector loadSignalChain(Inspector inspector,
                    String eventName, Object instance);

} // End interface
