package org.jcon.inspect;

import org.jcon.util.Hub;

/**
 * Provides simple local clipboard services. May change.
 * Java Clipboard not used.
 *
 * @author Jack Harich
 */
public class InspectClipboard {

//---------- Private Fields ------------------------------
private Object  value;
private Object  cookie; // *** NOT YET USED
private boolean empty = true;

//---------- Properties ----------------------------------
//----- value
public void setValue(Object value) {
    this.value = value;
    empty = false;
}
public Object getValue() {
    return value;
}
//----- cookie
public void setCookie(Object cookie) {
    this.cookie = cookie;
}
public Object getCookie() {
    return cookie;
}
//----- Other
public boolean isEmpty() {
    return empty;
}
//---------- Public Methods ------------------------------
public void clear() {
    value = null;
    cookie = null;
    empty = true;
}
//----- Static helper methods
/**
 * "Posts" a MethodArgument to the @param hub. If the
 * @param value is a String the MethodArgument is created
 * as a String. Otherwise it's created as a reference.
 */
public static void postMethodArgument(Hub hub,
                            Object value, Class type) {
    InspectClipboard clipboard = (InspectClipboard)
        hub.getNaming().get("Clipboard");
    MethodArgument argument;
    // String or Reference
    if (value.getClass().getName().equals("java.lang.String") ) {
        argument = new MethodArgument((String)value);
    } else {
        argument = new MethodArgument(value, type);
    }
    clipboard.setValue(argument);
    print(".postMethodArgument() - value = '" + value + "'");
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("InspectClipboard" + text);
}

} // End class
