package org.jcon.inspect;

import java.awt.Insets;

import javax.swing.JButton;

/**
 * A better JButton, with more reasonable insets.
 *
 * @author Jack Harich
 */
public class BetterJButton extends JButton {

//---------- Initialization ------------------------------
public BetterJButton(String text) {
    super(text);
}
//---------- Superclass Overrides ------------------------
public Insets getInsets() {
    // top, left, bottom, right
    // JButton is 4, 16, 4, 16
    return new Insets(4, 6, 4, 6);
}


} // End class
