package org.jcon.inspect;

import org.jcon.util.BeanLib;
import org.jcon.util.GenLib;
import java.beans.PropertyDescriptor;

/**
 * Represents a PropertyDescriptor plus the returned value
 * using Method.invoke(instance, args).
 *
 * @author Jack Harich
 */
public class BeanProperty {

//---------- Private Fields ------------------------------
private Object value;
private Class  returnType;
private PropertyDescriptor pd;

//---------- Initialization ------------------------------
public BeanProperty(Object value, PropertyDescriptor pd) {
    this.value = value;
    this.pd = pd;
    returnType = pd.getReadMethod().getReturnType();
}
//---------- Properties ----------------------------------
public Object getValue() {
    return value;
}
public String getPropertyName() {
    return pd.getName();
}
public String getTypeName() {
    return BeanLib.extractDisplayTypeName(returnType);
}
public Class getType() {
    return returnType;
}
public boolean isPrimitive() {
    return returnType.isPrimitive();
}
public boolean isArray() {
    return returnType.isArray();
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
