package org.jcon.df.work;

import org.jcon.df.edit.EditEvent;

/**
 * The interface for the source of rows for use by the
 * RowEditor, and possibly other uses. We will add methods
 * as needed. *** IN EVOLUTION ***
 * <p>
 * This source differs from the DataSource in that it does
 * not use the Database and Request subsystems. It allows
 * any method of supplying rows to be used, such as raw
 * sockets.
 *
 * @author Jack Harich
 */
public interface RowSource {
    
//---------- Events --------------------------------------    
public void addRowSetListener(RowSetListener listener);    

public void removeRowSetListener(RowSetListener listener);

//---------- Properties ----------------------------------
//----- ID
public void setID(String id);

public String getID();

//----- EntityName
public void setEntityName(String entityName);

public String getEntityName();

//---------- Public Methods ------------------------------
/**
 * The source should start working and fire initialization
 * related events that cause the view to be initially populated.
 */
public void start();

/**
* The source should process those events of interest and
* ignore the rest. Note that some are already handled.
*/
public void processEditEvent(EditEvent evt);




} // End interface
