package org.jcon.df.work;

/**
 * Provides a RowSet reader that can safely be retained for
 * long term use, such as by a view during an edit.
 *
 * @author Jack Harich
 */
public class RowSetReader {

//---------- Private Fields ------------------------------
private RowSet rowSet;

//---------- Properties ----------------------------------
public void setRowSet(RowSet rowSet) {
    this.rowSet = rowSet;
}
public int getRowCount() {
    return rowSet.getRowCount();
}
//---------- Public Methods ------------------------------
public Row getRowAt(int rowIndex) {
    return rowSet.getRowAt(rowIndex);
}
public Object getObject(int rowIndex, String columnID) {
    return rowSet.getRowAt(rowIndex).getValue(columnID);
}
public String getString(int rowIndex, String columnID) {
    return (String)rowSet.getRowAt(rowIndex).getValue(columnID);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("RowSetReader" + text);
}

} // End class
