package org.jcon.df.util.security;

import org.jcon.util.service.ContainerServices;

/**
* This class represents a single human user. It has the
* usual indentification and security related features.
* It's a pure data carrier with just getters and setters.
* It should be treated as immutable after initialization.
* *** (Mod later to enforce this.)
* <p>
* This class also enforces UserSys table integrity.
*
* @author Jack Harich
*/

public class User { 
   
//---------- Private Fields --------------------------    
private long        mid;  
private String      userID;
private String      firstName, middleInitial, lastName;    
private boolean     isAdmin;
private long        logonTime;
private long        userProfileMID;
  
/**@supplierCardinality 1*/
private UserProfile userProfile;      

//---------- Properties ------------------------------ 
//----- userMID
public void setMID(long mid) {
    this.mid = mid;
}
public long getMID() {
    return mid;
}                
//----- userID
public void setUserID(String userID) {
    this.userID = userID;
}
public String getUserID() {
    return userID;
}   
//--- firstName
public void setFirstName(String firstName) {
    this.firstName = firstName;
}
public String getFirstName() {
    return firstName;
}                               
//--- middleInitial
public void setMiddleInitial(String middleInitial) {
    this.middleInitial = middleInitial;
}                                
public String getMiddleInitial() {
    return middleInitial;
}                        
//----- lastName
public void setLastName(String lastName) {
    this.lastName = lastName;
}                            
public String getLastName() {
    return lastName;
}  
//----- isAdmin
public void setAdmin(boolean isAdmin) {
    this.isAdmin = isAdmin;
}
public boolean isAdmin() {
    return isAdmin;
}     
//----- logonTime
public void setLogonTime(long logonTime) {
    this.logonTime = logonTime;
}                              
public long getLogonTime() {
    return logonTime;
}
//----- userProfileMID
public void setUserProfileMID(long userProfileMID) {
    this.userProfileMID = userProfileMID;   
}    
public long getUserProfileMID() {
    return userProfileMID;   
}    
//----- userProfile
public void setUserProfile(UserProfile userProfile) {
    this.userProfile = userProfile;
}
public UserProfile getUserProfile() {
    return userProfile;
} 
//----- Other   
public String getFullName() {
    return firstName = " " + middleInitial + " " + lastName;
}
public String getAlphabeticalFullName() {
    return lastName + ", " + firstName + " " + middleInitial;
}  
//---------- Public Methods ------------------------------
public boolean isAllowed(String secureItem) {
    if (isAdmin) {
        return true;
    } else {
        return userProfile.isAllowed(secureItem);
    }
}   

} // End class





































