package org.jcon.df.util.security;
                     
/**
* This class provides user security services, such as
* using "SecureItem" names to determine user access. It is
* designed to be easily enhanced in the future, as the user
* security subsystem matures.
* <p>
* This class is a Fascade for the UserSecurity class, and
* exposes only certain behavior.
*
* @author Jack Harich
*/
public class SecurityServices {  
    	                 
//---------- Private Fields ------------------------------ 
/**@supplierCardinality 1*/
private UserSecurity userSecurity;
                         
//---------- Public Methods ------------------------------    
/**
* Returns true if the current user is allowed access to
* the named secure item, false if not. If the secureItem
* doesn't exist then a complaint is shown and false is
* returned.
*/
public boolean isAllowed(String secureItem) {
    return userSecurity.isAllowed(secureItem);
}
//---------- Package Methods -----------------------------    
// For callbacks
void setUserSecurity(UserSecurity userSecurity) {
    this.userSecurity = userSecurity;
} 

} // End class











