package org.jcon.df.request;

import org.jcon.util.GenLib;
import java.sql.Statement;

/**
 * A request to remove a table from a database. Only one
 * table name should be supplied.
 *
 * @author Jack Harich
 */
public class RemoveTable extends DataRequest {

//---------- Private Fields ------------------------------
private String sql;

//---------- Abstract Implementation ---------------------
public boolean isMutator() {
    return true;
}
public Object perform() {
    if (sql == null) prepare();
    try {
        requestServices.getStatement().executeUpdate(sql);

    } catch(Exception ex) {
        GenLib.exception("RemoveTable.perform()",
            "Cannot remove table using SQL = " + sql, ex);
        // Exception probably means table not in database
        this.setFailureText("Exception, table may not be in database");
        this.setFailureSQL(sql);
        this.setFailureException(ex);
    }
    return this;
}
//---------- Superclass Overrides ------------------------
public void prepare() {
    try {
        sql = requestServices.getTranslator()
            .buildDropTableStm(this);

    } catch(Exception ex) {
        ex.printStackTrace();
        this.setFailureText("Cannot translate to SQL.");
        this.setFailureException(ex);
        throw new IllegalStateException("Cannot translate to SQL.");
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("RemoveTable" + text);
}

} // End class
