package org.jcon.df.request;

import org.jcon.util.GenLib;
import java.sql.Statement;

/**
 * Deletes rows in a single entity with no cascade delete.
 * If the filter is null all rows are removed.
 *
 * @author Jack Harich
 */
public class RemoveRowsNoCascade extends DataRequest {

//---------- Private Fields ------------------------------
private int count = -1;
private String sql;

//---------- Abstract Implementation ---------------------
public boolean isMutator() {
    return true;
}
public Object perform() {

    if (sql == null) prepare();
    try {
        // Execute
        count = requestServices.getStatement()
            .executeUpdate(sql);
        //print(".perform() - count removed = " + count);

    } catch(Exception ex) {
        GenLib.exception("RemoveRowsNoCascade.perform()",
            "Cannot delete rows using SQL = " + sql, ex);
        // Exception probably means table not in database
        count = -1;
        this.setFailureText("Exception, table may not be in database");
        this.setFailureSQL(sql);
        this.setFailureException(ex);
    }
    return this;
}
//---------- Superclass Overrides ------------------------
public void prepare() {
    try {
        sql = requestServices.getTranslator()
            .buildDeleteStm(this);

    } catch(Exception ex) {
        ex.printStackTrace();
        this.setFailureText("Cannot translate to SQL.");
        this.setFailureException(ex);
        throw new IllegalStateException("Cannot translate to SQL.");
    }
}
//---------- Properties ----------------------------------
/**
 * Returns the number of rows deleted, which is -1 if
 * failure. Note - This appears to always be 0 on Access.
 */
public int getNumberRowsDeleted() {
    return count;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("RemoveRowsNoCascade" + text);
}

} // End class
