package org.jcon.df.request;

import org.jcon.util.GenLib;
import java.sql.Statement;

/**
 * A request to remove rows in an entity using cascade
 * delete. If the filter is null all rows are removed,
 * which would have the effect of emptying the prime
 * entity and all children.
 *
 * @author Jack Harich
 */
public class RemoveRows extends DataRequest {

//---------- Private Fields ------------------------------
private int count = -1;
private String sql;

//---------- Abstract Implementation ---------------------
public boolean isMutator() {
    return true;
}
public Object perform() {

    try {
        // Execute
        count = CascadeDelete.performDelete(this, requestServices);
        //print(".perform() - count removed = " + count);

    } catch(Exception ex) {
        GenLib.exception("RemoveRows.perform()",
            "Cannot delete rows using SQL = " + sql, ex);
        // Exception probably means table not in database
        count = -1;
        this.setFailureText("Exception, table may not be in database");
        this.setFailureSQL(sql);
        this.setFailureException(ex);
    }
    return this;
}
//---------- Superclass Overrides ------------------------
// sql not used to perform, but useful in setFailureSQL()
public void prepare() {
    try {
        sql = requestServices.getTranslator()
            .buildDeleteStm(this);

    } catch(Exception ex) {
        ex.printStackTrace();
        this.setFailureText("Cannot translate to SQL.");
        this.setFailureException(ex);
        throw new IllegalStateException("Cannot translate to SQL.");
    }
}
//---------- Properties ----------------------------------
/**
 * Returns the number of rows deleted in the prime entity,
 * which is -1 if failure.
 * Note - This appears to always be 0 on Access.
 */
public int getNumberRowsDeleted() {
    return count;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("RemoveRows" + text);
}

} // End class
