package org.jcon.df.request;

import org.jcon.df.work.Row;
import org.jcon.util.GenLib;
import java.sql.Statement;

/**
 * A request to remove a row from an entity.
 * *** REMOVED, now using only RemoveRows ***
 *
 * @author Jack Harich
 */
public class RemoveRow extends DataRequest {

//---------- Private Fields ------------------------------
private String entityName;
private String sql;

//---------- Abstract Implementation ---------------------
public boolean isMutator() {
    return true;
}
public Object perform() {
    if (sql == null) prepare();
    try {
        // Prep
        // *** Later check referential integrity **********

        // Execute
        requestServices.getStatement().executeUpdate(sql);

    } catch(Exception ex) {
        GenLib.exception("RemoveRow.perform()",
            "Cannot Remove row using SQL: " + sql, ex);
        this.setFailureText("Cannot remove row.");
        this.setFailureSQL(sql);
        this.setFailureException(ex);
    }
    return this;
}
//---------- Superclass Overrides ------------------------
public void prepare() {
    // Preconditions
    if (entityName == null) {
        throw new IllegalStateException("Failure to" +
        " set entityName.\nCannot remove row without an entityName.");
    }
    try {
        sql = requestServices.getTranslator()
            .buildDeleteStm(this);

    } catch(Exception ex) {
        ex.printStackTrace();
        this.setFailureText("Cannot translate to SQL.");
        this.setFailureException(ex);
        throw new IllegalStateException("Cannot translate to SQL.");
    }
}
//---------- Properties ----------------------------------
/**
 * Specifies the entity the row will be removed from.
 */
public void setEntityName(String entityName) {
    if (this.entityName == null) {
        addEntity(entityName);
        this.entityName = entityName;
    } else {
        GenLib.error("RemoveRow.setEntityName()",
            "EntityName already set to '" + this.entityName + "'.");
    }
}
public String getEntityName() {
    return entityName;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("RemoveRow" + text);
}

} // End class
