package org.jcon.df.request;

import org.jcon.util.DataLib;

/**
 * Represents a column expression, such as Name = "Jill".
 * Used for inserts and filters, which have such expressions
 * in their SQL statements.
 *
 * @author Jack Harich
 */
public class ColumnExp implements java.io.Serializable {

//---------- Private Fields ------------------------------
private String columnID;
private String operator;
private String value;
private String formattedValue;

//---------- Properties ----------------------------------
//----- columnID
public void setColumnID(String columnID) {
    this.columnID = columnID;
}
public String getColumnID() {
    return columnID;
}
//----- operator
public void setOperator(String operator) {
    this.operator = operator;
}
public String getOperator() {
    return operator;
}
//----- value
public void setValue(String value) {
    this.value = value;
}
public String getValue() {
    return value;
}
/**
 * Returns true if the value is null or "", false otherwise.
 */
public boolean isValueEmpty() {
    if (value == null) {
        return true;
    } else if(value.equals("")) {
        return true;
    } else {
        return false;
    }
}
//----- formattedValue
public void setFormattedValue(String formattedValue) {
    this.formattedValue = formattedValue;
}
public String getFormattedValue() {
    return formattedValue;
}
//----- Other
public String getEntityName() {
    return DataLib.getFirstDelimited(columnID, '.');
}
public String getColumnName() {
    return DataLib.getLastDelimited(columnID, '.');
}
//---------- Public Methods ------------------------------
public String getFormattedExpression() {
    String op = operator;
    if (op.equalsIgnoreCase("NOTLIKE")) op = "NOT LIKE";

    // No space before value possibly causes bug in
    // MSAccess JDBC driver, so use no space.
    return columnID + op  + formattedValue;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ColumnExp" + text);
}

} // End class
