package org.jcon.df.request;

// import org.jcon.util.GenLib;

/**
 * Maps a logical datatype (a ColumnDef type) to a physical
 * database datatype. Useful for translation.
 *
 * @author Jack Harich
 */
public class ColumnDefType implements java.io.Serializable {

//---------- Private Fields ------------------------------
private String name; // Name of the ColumnDef type
private String datatype;
private String prefix;
private String suffix;

//---------- Initialization ------------------------------
public ColumnDefType() {
}
public ColumnDefType(String name, String datatype,
        String prefix, String suffix) {
    this.name = name;
    this.datatype = datatype;
    this.prefix = prefix;
    this.suffix = suffix;
}
//---------- Properties ----------------------------------
//----- name
public void setName(String name) {
    this.name = name;
}
public String getName() {
    return name;
}
//----- datatype
public void setDatatype(String datatype) {
    this.datatype = datatype;
}
public String getDatatype() {
    return datatype;
}
//----- prefix
public void setPrefix(String prefix) {
    this.prefix = prefix;
}
public String getPrefix() {
    return prefix;
}
//----- suffix
public void setSuffix(String suffix) {
    this.suffix = suffix;
}
public String getSuffix() {
    return suffix;
}
//---------- Public Methods ------------------------------
/**
 * Formats the value to that needed by an SQL string, which
 * is prefix + value + suffix.
 * Output examples are 10, 'test' and $100.
 */
public String formatToSQL(String value) {
    return prefix + value + suffix;
}


} // End class
