package org.jcon.df.edit.widget;

/**
 * This class is a polymorphic event occuring in a WidgetSet. 
 *
 * @author Jack Harich
 */
public class WidgetSetEvent {

//---------- Public Fields -------------------------------
public static final int ACTION = 1;

//---------- Private Fields ------------------------------
// Properties
private int    eventType;
private String viewName;
private String actionCommand;

//---------- Initialization ------------------------------
public WidgetSetEvent(int eventType, String viewName) {
    this.eventType = eventType;
    this.viewName  = viewName;
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public String getEventTypeString() {
    if (eventType == ACTION) return "Action";
    
    return "#UnknownType#";
}
public int getEventType() {
    return eventType;
}
//----- ViewName
public String getViewName() {
    return viewName;
}
//----- ActionCommand
public void setActionCommand(String actionCommand) {
    this.actionCommand = actionCommand;
}
public String getActionCommand() {
    return actionCommand;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("WidgetSetEvent" + text);
}

} // End class
