package org.jcon.df.edit.widget;

import org.jcon.df.edit.EditListener;
import org.jcon.df.work.RowSetListener;
import org.jcon.param.Param;
import java.awt.Component;

/**
 * The interface for "Widgets", which are modular
 * components for assemblying a view.
 *
 * @author Jack Harich
 */
public interface Widget {

//---------- Widget Implementation -----------------------
/**
* Sets the widget name, which is unique per window.
*/
public void setName(String name);

/**
* Returns the widget name.
*/
public String getName();

/**
 * Instructs the widget to configure itself using the
 * param. Some may have nothing to do.
 */
public void setParam(Param param);

/**
 * Returns the component to add to the view.
 */
public Component getComponent();

/**
* The widget should set the focus on the appropriate
* Component, behave appropriately or do nothing if it
* cannot receive the focus.
*/
public void requestFocus();

/**
 * Sets the listener for all DataEditEvents. The listener
 * is the controller.
 */
public void setEditListener(EditListener controller);


} // End interface
