package org.jcon.df.edit.task;

import org.jcon.util.GenLib;
import org.jcon.param.Param;

/**
 * Creates Tasks on demand.
 *
 * @author Jack Harich
 */
public class TaskFactory {

//---------- Private Fields ------------------------------
private TaskContext taskContext;

//---------- Properties ----------------------------------
public void setTaskContext(TaskContext taskContext) {
    this.taskContext = taskContext;
}
//---------- Public Methods ------------------------------
public Task createTask(Param param) {
    String taskType = param.getString("TaskType").intern();
    // Set className
    String className;
    if (taskType == "EditFields") {
        className = "org.jcon.df.edit.task.EditFieldsTask";

    } else if (taskType == "BrowseEditFields") {
        className = "org.jcon.df.edit.task.BrowseEditFieldsTask";

    } else {
        throw new IllegalArgumentException("Unknown " +
            "TaskType '" + taskType + "'.");
    }
    // Create and config Task
    //print(".createTask() - Creating " + className);
    Task task = (Task)GenLib.createInstance(className);
    task.setTaskContext(taskContext);
    task.setMetaParam(param);

    return task;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TaskFactory" + text);
}

} // End class
