package org.jcon.df.edit.task;

// import org.jcon.util.GenLib;
import org.jcon.df.edit.DataEditor;
import org.jcon.df.edit.DataView;
import org.jcon.df.Schema;

/**
 * Provides a Task with services appropriate to its
 * context. This allows the Task to collaborate with its
 * environment while maintaining environment encapsulation.
 *
 * @author Jack Harich
 */
public class TaskContext {

//---------- Private Fields ------------------------------
private DataEditor dataEditor;
private String dbName;

//---------- Initialization ------------------------------
public TaskContext(DataEditor dataEditor, String dbName) {
    this.dataEditor = dataEditor;
    this.dbName = dbName;
}
//---------- Properties ----------------------------------
//----- Getters
public DataView getView(String viewName) {
    return dataEditor.getView(viewName);
}
public Schema getSchema() {
    return dataEditor.getSchema(dbName);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TaskContext" + text);
}

} // End class
